/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_PS3_MUTEX_H
#define _SCE_PS3_MUTEX_H

#include "mutex.h"
#include <sys/synchronization.h>

namespace sce {
	namespace Toolkit{
		namespace NP{
			namespace Utilities {

		/// @brief
		/// The implementation of the <c>Mutex</c> class for the for PS3 platform.
		///
		/// The implementation of the <c>Mutex</c> class for the for PS3 platform.
		class MutexImpl : public Mutex{
		public:

			/// @brief 
			/// The constructor for the MutexImpl class.
			///
			/// The constructor for the MutexImpl class. The object must be initialized after construction.
			MutexImpl() : m_mutex() {}

			/// @brief 
			/// The destructor for the MutexImpl class.
			///
			/// The destructor for the MutexImpl class. The object must be terminated before destruction.
			~MutexImpl() {}

			/// @brief
			/// Initializes this object.
			///
			/// Initializes this object.
			//
			/// @return Returns SCE_TOOLKIT_NP_SUCCESS or a generic error value.
			int init();

			/// @brief
			/// Terminates this object.
			///
			/// Terminates this object.
			//
			/// @return Returns SCE_TOOLKIT_NP_SUCCESS or a generic error value.
			int term();

			/// @brief
			/// Locks this object.
			///
			/// Locks this object.
			//
			/// @return Returns SCE_TOOLKIT_NP_SUCCESS or a generic error value.
			int lock();

			/// @brief
			/// Unlocks this object.
			///
			/// Unlocks this object.
			//
			/// @return Returns SCE_TOOLKIT_NP_SUCCESS or a generic error value.
			int unlock();
	
			/// @brief
			/// Tries the lock of this object.
			///
			/// Tries the lock of this object.
			//
			/// @return Returns SCE_TOOLKIT_NP_SUCCESS or a generic error value.
			int tryLock();
		private:
			friend class ConditionVariableImpl;
			sys_mutex_t m_mutex;
		};

			}//end Utilites
		}//end NP
	}//end Toolkit
}//end sce
#endif
